var wallhack = {

    identifier: '',
    gameKey: '',
    properties: {},
    displayName: '',
    serverAddress: 'http://dash.wallhack.io/api',

    /**
     * Sets displayname.
     *
     * @param displayname
     */
    setDisplayName: function (displayname) {
        this.displayName = displayname;
    },

    /**
     * Gets displayname.
     *
     * @returns {string}
     */
    getDisplayName: function () {
        return this.displayName;
    },

    /**
     * Sets the game's Key.
     *
     * @param gameKey
     */
    setKey: function (gameKey) {
        this.gameKey = gameKey;
    },

    /**
     * Returns the game's key.
     *
     * @returns {string}
     */
    getKey: function () {
        return this.gameKey;
    },

    /**
     * Sets the profile's UUID.
     *
     * @param identifier
     */
    setIdentifier: function (identifier) {
        this.identifier = identifier;
    },

    /**
     * Returns the profile's UUID.
     *
     * @returns {string}
     */
    getIdentifier: function () {
        return this.identifier;
    },

    /**
     * Sends an event to the serverAddress.
     *
     * @param event event string
     * @param body (optional) body string to send with the request.
     */
    sendEvent: function (event, body) {
        let that = this;
        setTimeout(function() {
            $.ajax({
                data: {
                    "clientIdentifier": that.identifier,
                    "gameKey": that.gameKey,
                    "eventName": event,
                    "eventBody": JSON.stringify(body)
                },
                method: "post",
                url: that.serverAddress + '/events'
            }).done(function (data) {

            }).fail(function (xhr, status, error) {

            });
        }, 3000);
    },

    /**
     * Registers a new profile.
     */
    registerProfile: function (identifier, gameKey, displayName) {

        this.setKey(gameKey);
        this.setIdentifier(identifier);
        this.setDisplayName(displayName);

        $.ajax({
            data: {
                "clientIdentifier": this.identifier,
                "gameKey": this.gameKey,
                "displayName": this.displayName
            },
            method: "post",
            url: this.serverAddress + '/profiles'
        }).done(function (data) {

        }).fail(function (xhr, status, error) {

        });

        this.sendKeepalive(this.identifier, this.serverAddress);
    },

    /**
     * Updates properties
     *
     * @param properties can either be a single object or multiple. ie. { hello : 'world' } or
     * { hello : 'world', foo : 'bar' }
     *
     */
    setProperties: function (properties) {
        var that = this;
        setTimeout(function() {
            $.ajax({
                data: {
                    "clientIdentifier": that.identifier,
                    "gameKey": that.gameKey,
                    "properties": properties
                },
                method: "post",
                url: that.serverAddress + '/properties'
            }).done(function (data) {
            }).fail(function (xhr, status, error) {
            });
        }, 2000);
    },

    /**
     * Returns an object of the current set properties.
     *
     * @returns Object of properties
     */
    getProperties: function () {
        return this.properties;
    },

    /**
     * Sends a keepalive message to the server to keep a session open.
     */
    sendKeepalive: function (identifier, serverAddress) {
        //TODO THIS IS MESSY
        var that = this;
        setTimeout(function() {
            $.ajax({
                data: {
                    "clientIdentifier": identifier
                },
                method: "post",
                url: serverAddress + '/sessions'
            }).done(function (data) {

            }).fail(function (xhr, status, error) {

            });
        }, 2000);

        setInterval(function () {
            $.ajax({
                data: {
                    "clientIdentifier": identifier
                },
                method: "post",
                url: serverAddress + '/sessions'
            }).done(function (data) {

            }).fail(function (xhr, status, error) {

            });
        }, 60000);

    }

};

if(typeof exports !== 'undefined'){
    module.exports = wallhack;
}